<?php
/**
 *
 * The framework's functions and definitions
 */
// Mendapatkan objek peran 'customer'
$customer_role = get_role('customer');

// Menambahkan kemampuan untuk mengunggah file
$customer_role->add_cap('upload_files');

define( 'WOODMART_THEME_DIR', get_template_directory_uri() );
define( 'WOODMART_THEMEROOT', get_template_directory() );
define( 'WOODMART_IMAGES', WOODMART_THEME_DIR . '/images' );
define( 'WOODMART_SCRIPTS', WOODMART_THEME_DIR . '/js' );
define( 'WOODMART_STYLES', WOODMART_THEME_DIR . '/css' );
define( 'WOODMART_FRAMEWORK', '/inc' );
define( 'WOODMART_DUMMY', WOODMART_THEME_DIR . '/inc/dummy-content' );
define( 'WOODMART_CLASSES', WOODMART_THEMEROOT . '/inc/classes' );
define( 'WOODMART_CONFIGS', WOODMART_THEMEROOT . '/inc/configs' );
define( 'WOODMART_HEADER_BUILDER', WOODMART_THEME_DIR . '/inc/header-builder' );
define( 'WOODMART_ASSETS', WOODMART_THEME_DIR . '/inc/admin/assets' );
define( 'WOODMART_ASSETS_IMAGES', WOODMART_ASSETS . '/images' );
define( 'WOODMART_API_URL', 'https://xtemos.com/wp-json/xts/v1/' );
define( 'WOODMART_DEMO_URL', 'https://woodmart.xtemos.com/' );
define( 'WOODMART_PLUGINS_URL', WOODMART_DEMO_URL . 'plugins/' );
define( 'WOODMART_DUMMY_URL', WOODMART_DEMO_URL . 'dummy-content-new/' );
define( 'WOODMART_TOOLTIP_URL', WOODMART_DEMO_URL . 'theme-settings-tooltips/' );
define( 'WOODMART_SLUG', 'woodmart' );
define( 'WOODMART_CORE_VERSION', '1.0.42' );
define( 'WOODMART_WPB_CSS_VERSION', '1.0.2' );

if ( ! function_exists( 'woodmart_load_classes' ) ) {
	function woodmart_load_classes() {
		$classes = array(
			'class-singleton.php',
			'class-api.php',
			'class-config.php',
			'class-layout.php',
			'class-autoupdates.php',
			'class-activation.php',
			'class-notices.php',
			'class-theme.php',
			'class-registry.php',
		);

		foreach ( $classes as $class ) {
			require WOODMART_CLASSES . DIRECTORY_SEPARATOR . $class;
		}
	}
}


add_action('template_redirect', 'redirect_non_logged_in_users');

function redirect_non_logged_in_users() {
    // Periksa apakah pengguna belum login dan sedang mengakses halaman submit blog
    if (!is_user_logged_in() && is_page('Post Submit')) {
        // Redirect pengguna ke halaman akun
        wp_redirect(home_url('/my-account'));
        exit;
    }
}

function tambahkan_menu_write_article( $menu_links ){
    // Ganti 'https://example.com/write-article' dengan URL aktual halaman "Write Article" Anda
    $menu_links['post-submit'] = 'Write Article';
    return $menu_links;
}
add_filter( 'woocommerce_account_menu_items', 'tambahkan_menu_write_article' );


function user_posts_check(){
	  // Dapatkan ID pengguna yang sedang login
        $current_user_id = get_current_user_id();

        // Buat query untuk menghitung jumlah postingan yang dibuat oleh pengguna
        $user_post_count = new WP_Query(array(
            'author' => $current_user_id,
            'post_type' => 'post',
            'post_status' => 'publish',
            'posts_per_page' => -1 // Ambil semua postingan
        ));

        // Hitung jumlah postingan yang dibuat oleh pengguna
        $total_user_posts = $user_post_count->found_posts;
	
	if($total_user_posts==0){
		echo "<p>Anda Belum Memiliki Postingan</p>";
	}else {
		echo do_shortcode("[usp_display_posts userid=".$current_user_id."]  ");
	}
}

add_shortcode('current_user_posts', 'user_posts_check');


function replace_comment_links($comment_text) {
	
	//jika admin maka tidak perlu direplace
	 
	if( current_user_can('administrator') ) {
 		return $comment_text;
 	}
	
    // Regex untuk mencari link
    $link_regex = '/\b(http:\/\/|https:\/\/|www\.)\S+\b/i';
    // Link pengganti
     $replace_options = array('https://sepatuindonesia.com/', 'https://sepatuindonesia.com/product', 'https://sepatuindonesia.com/blog');
    $replacement_link = $replace_options[array_rand($replace_options)];
    // Mengganti link di komentar dengan link pengganti
    $comment_text = preg_replace($link_regex, $replacement_link, $comment_text);
    return $comment_text;
}

// Hook untuk memodifikasi teks komentar sebelum ditampilkan
add_filter('preprocess_comment', 'replace_comment_links');

function redirect_404_to_homepage() {
    if (is_404()) {
        wp_redirect(home_url());
        exit();
    }
}
add_action('template_redirect', 'redirect_404_to_homepage');

woodmart_load_classes();

new XTS\Theme();

define( 'WOODMART_VERSION', woodmart_get_theme_info( 'Version' ) );
